//
//
// Description: This file is part of FET
//
//
// Author: Liviu Lalescu (Please see https://lalescu.ro/liviu/ for details about contacting Liviu Lalescu (in particular, you can find there the email address))
// Copyright (C) 2016 Liviu Lalescu <https://lalescu.ro/liviu/>
//
/***************************************************************************
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU Affero General Public License as        *
 *   published by the Free Software Foundation, version 3 of the License.  *
 *                                                                         *
 ***************************************************************************/

#include "timetable_defs.h"

#include "settingsdatatoprintintimetablesform.h"

SettingsDataToPrintInTimetablesForm::SettingsDataToPrintInTimetablesForm(QWidget* parent): QDialog(parent)
{
	setupUi(this);
	
	tabWidget->setUsesScrollButtons(true);
	tabWidget->setCurrentIndex(0);
	
	centerWidgetOnScreen(this);
	restoreFETDialogGeometry(this);
	
	okPushButton->setDefault(true);
	
	connect(okPushButton, &QPushButton::clicked, this, &SettingsDataToPrintInTimetablesForm::wasAccepted);
	connect(cancelPushButton, &QPushButton::clicked, this, &SettingsDataToPrintInTimetablesForm::wasCanceled);
	
	subjectsCheckBox->setChecked(TIMETABLE_HTML_PRINT_SUBJECTS);
	activityTagsCheckBox->setChecked(TIMETABLE_HTML_PRINT_ACTIVITY_TAGS);
	teachersCheckBox->setChecked(TIMETABLE_HTML_PRINT_TEACHERS);
	studentsCheckBox->setChecked(TIMETABLE_HTML_PRINT_STUDENTS);
	roomsCheckBox->setChecked(TIMETABLE_HTML_PRINT_ROOMS);
	
	//2024-06-12
	separateDaysNameLongNameByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_DAYS_NAME_LONG_NAME_BY_BREAK);
	separateHoursNameLongNameByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_HOURS_NAME_LONG_NAME_BY_BREAK);
	separateSubjectsNameLongNameCodeByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_SUBJECTS_NAME_LONG_NAME_CODE_BY_BREAK);
	separateActivityTagsNameLongNameCodeByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_ACTIVITY_TAGS_NAME_LONG_NAME_CODE_BY_BREAK);
	separateTeachersNameLongNameCodeByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_TEACHERS_NAME_LONG_NAME_CODE_BY_BREAK);
	separateStudentsNameLongNameCodeByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_STUDENTS_NAME_LONG_NAME_CODE_BY_BREAK);
	separateBuildingsNameLongNameCodeByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_BUILDINGS_NAME_LONG_NAME_CODE_BY_BREAK);
	separateRoomsNameLongNameCodeByBreakCheckBox->setChecked(SETTINGS_TIMETABLES_SEPARATE_ROOMS_NAME_LONG_NAME_CODE_BY_BREAK);
	
	 //only in days horizontal and days vertical.
	writeSubjectsCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_SUBJECTS_COMMENTS);
	writeActivityTagsCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_ACTIVITY_TAGS_COMMENTS);
	writeTeachersCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_TEACHERS_COMMENTS);
	writeSubgroupsCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_SUBGROUPS_COMMENTS);
	writeGroupsCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_GROUPS_COMMENTS);
	writeYearsCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_YEARS_COMMENTS);
	writeBuildingsCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_BUILDINGS_COMMENTS);
	writeRoomsCommentsInDaysHVCheckBox->setChecked(SETTINGS_TIMETABLES_PRINT_ROOMS_COMMENTS);
	
	/////subgroups days horizontal and days vertical.
	subgroupsDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_DAYS_NAMES);
	subgroupsDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	subgroupsDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_HOURS_NAMES);
	subgroupsDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	subgroupsDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	subgroupsDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	subgroupsDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	subgroupsDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	subgroupsDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	subgroupsDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	subgroupsDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_NAMES);
	subgroupsDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	subgroupsDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	subgroupsDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_NAMES);
	subgroupsDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	subgroupsDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	subgroupsDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_NAMES);
	subgroupsDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	subgroupsDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_CODES);

	subgroupsDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	subgroupsDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	subgroupsDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	subgroupsDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	subgroupsDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_LEGEND);
	subgroupsDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////subgroups time horizontal and time vertical.
	subgroupsTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_DAYS_NAMES);
	subgroupsTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	subgroupsTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_HOURS_NAMES);
	subgroupsTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	subgroupsTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_NAMES);
	subgroupsTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	subgroupsTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	subgroupsTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	subgroupsTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	subgroupsTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	subgroupsTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_NAMES);
	subgroupsTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	subgroupsTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_CODES);
	
	subgroupsTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_NAMES);
	subgroupsTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	subgroupsTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_CODES);
	
	subgroupsTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_NAMES);
	subgroupsTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	subgroupsTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_CODES);

	subgroupsTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	subgroupsTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	subgroupsTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_LEGEND);
	subgroupsTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_LEGEND);
	subgroupsTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_LEGEND);
	subgroupsTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////groups days horizontal and days vertical.
	groupsDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_DAYS_NAMES);
	groupsDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	groupsDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_HOURS_NAMES);
	groupsDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	groupsDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	groupsDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	groupsDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	groupsDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	groupsDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	groupsDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	groupsDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_NAMES);
	groupsDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	groupsDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	groupsDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_NAMES);
	groupsDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	groupsDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	groupsDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_NAMES);
	groupsDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	groupsDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_CODES);

	groupsDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	groupsDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	groupsDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	groupsDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	groupsDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_LEGEND);
	groupsDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////groups time horizontal and time vertical.
	groupsTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_DAYS_NAMES);
	groupsTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	groupsTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_HOURS_NAMES);
	groupsTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	groupsTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_NAMES);
	groupsTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	groupsTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	groupsTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	groupsTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	groupsTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	groupsTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_NAMES);
	groupsTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	groupsTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_CODES);
	
	groupsTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_NAMES);
	groupsTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	groupsTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_CODES);
	
	groupsTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_NAMES);
	groupsTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	groupsTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_CODES);

	groupsTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	groupsTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	groupsTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_LEGEND);
	groupsTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_LEGEND);
	groupsTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_LEGEND);
	groupsTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////years days horizontal and days vertical.
	yearsDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_DAYS_NAMES);
	yearsDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	yearsDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_HOURS_NAMES);
	yearsDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	yearsDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	yearsDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	yearsDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	yearsDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	yearsDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	yearsDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	yearsDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_NAMES);
	yearsDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	yearsDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	yearsDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_NAMES);
	yearsDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	yearsDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	yearsDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_NAMES);
	yearsDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	yearsDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_CODES);

	yearsDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	yearsDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	yearsDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	yearsDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	yearsDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_LEGEND);
	yearsDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////years time horizontal and time vertical.
	yearsTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_DAYS_NAMES);
	yearsTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	yearsTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_HOURS_NAMES);
	yearsTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	yearsTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_NAMES);
	yearsTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	yearsTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	yearsTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	yearsTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	yearsTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	yearsTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_NAMES);
	yearsTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	yearsTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_CODES);
	
	yearsTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_NAMES);
	yearsTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	yearsTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_CODES);
	
	yearsTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_NAMES);
	yearsTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	yearsTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_CODES);

	yearsTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	yearsTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	yearsTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_LEGEND);
	yearsTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_LEGEND);
	yearsTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_LEGEND);
	yearsTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////teachers days horizontal and days vertical.
	teachersDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_DAYS_NAMES);
	teachersDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	teachersDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_HOURS_NAMES);
	teachersDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	teachersDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	teachersDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	teachersDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	teachersDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	teachersDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	teachersDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	teachersDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_NAMES);
	teachersDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	teachersDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	teachersDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_NAMES);
	teachersDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	teachersDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	teachersDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_NAMES);
	teachersDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	teachersDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_CODES);

	teachersDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	teachersDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	teachersDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	teachersDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	teachersDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_LEGEND);
	teachersDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////teachers time horizontal and time vertical.
	teachersTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_DAYS_NAMES);
	teachersTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	teachersTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_HOURS_NAMES);
	teachersTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	teachersTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_NAMES);
	teachersTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	teachersTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	teachersTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	teachersTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	teachersTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	teachersTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_NAMES);
	teachersTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	teachersTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_CODES);
	
	teachersTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_NAMES);
	teachersTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	teachersTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_CODES);
	
	teachersTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_NAMES);
	teachersTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	teachersTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_CODES);

	teachersTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	teachersTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	teachersTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_LEGEND);
	teachersTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_LEGEND);
	teachersTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_LEGEND);
	teachersTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////rooms days horizontal and days vertical.
	roomsDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_DAYS_NAMES);
	roomsDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	roomsDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_HOURS_NAMES);
	roomsDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	roomsDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	roomsDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	roomsDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	roomsDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	roomsDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	roomsDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	roomsDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_NAMES);
	roomsDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	roomsDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	roomsDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_NAMES);
	roomsDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	roomsDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	roomsDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_NAMES);
	roomsDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	roomsDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_CODES);

	roomsDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	roomsDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	roomsDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	roomsDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	roomsDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_LEGEND);
	roomsDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////rooms time horizontal and time vertical.
	roomsTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_DAYS_NAMES);
	roomsTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	roomsTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_HOURS_NAMES);
	roomsTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	roomsTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_NAMES);
	roomsTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	roomsTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	roomsTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	roomsTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	roomsTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	roomsTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_NAMES);
	roomsTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	roomsTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_CODES);
	
	roomsTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_NAMES);
	roomsTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	roomsTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_CODES);
	
	roomsTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_NAMES);
	roomsTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	roomsTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_CODES);

	roomsTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	roomsTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	roomsTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_LEGEND);
	roomsTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_LEGEND);
	roomsTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_LEGEND);
	roomsTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////buildings days horizontal and days vertical.
	buildingsDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_DAYS_NAMES);
	buildingsDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	buildingsDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_HOURS_NAMES);
	buildingsDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	buildingsDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	buildingsDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	buildingsDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	buildingsDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	buildingsDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	buildingsDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	buildingsDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_NAMES);
	buildingsDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	buildingsDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	buildingsDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_NAMES);
	buildingsDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	buildingsDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	buildingsDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_NAMES);
	buildingsDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	buildingsDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_CODES);

	buildingsDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	buildingsDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	buildingsDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	buildingsDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	buildingsDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_LEGEND);
	buildingsDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////buildings time horizontal and time vertical.
	buildingsTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_DAYS_NAMES);
	buildingsTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	buildingsTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_HOURS_NAMES);
	buildingsTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	buildingsTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_NAMES);
	buildingsTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	buildingsTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	buildingsTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	buildingsTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	buildingsTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	buildingsTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_NAMES);
	buildingsTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	buildingsTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_CODES);
	
	buildingsTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_NAMES);
	buildingsTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	buildingsTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_CODES);
	
	buildingsTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_NAMES);
	buildingsTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	buildingsTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_CODES);

	buildingsTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	buildingsTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	buildingsTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_LEGEND);
	buildingsTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_LEGEND);
	buildingsTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_LEGEND);
	buildingsTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////subjects days horizontal and days vertical.
	subjectsDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_DAYS_NAMES);
	subjectsDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	subjectsDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_HOURS_NAMES);
	subjectsDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	subjectsDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	subjectsDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	subjectsDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	subjectsDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	subjectsDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	subjectsDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	subjectsDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_NAMES);
	subjectsDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	subjectsDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	subjectsDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_NAMES);
	subjectsDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	subjectsDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	subjectsDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_NAMES);
	subjectsDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	subjectsDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_CODES);

	subjectsDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	subjectsDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	subjectsDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	subjectsDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	subjectsDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_LEGEND);
	subjectsDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////subjects time horizontal and time vertical.
	subjectsTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_DAYS_NAMES);
	subjectsTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	subjectsTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_HOURS_NAMES);
	subjectsTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	subjectsTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_NAMES);
	subjectsTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	subjectsTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	subjectsTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	subjectsTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	subjectsTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	subjectsTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_NAMES);
	subjectsTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	subjectsTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_CODES);
	
	subjectsTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_NAMES);
	subjectsTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	subjectsTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_CODES);
	
	subjectsTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_NAMES);
	subjectsTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	subjectsTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_CODES);

	subjectsTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	subjectsTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	subjectsTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_LEGEND);
	subjectsTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_LEGEND);
	subjectsTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_LEGEND);
	subjectsTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////activity tags days horizontal and days vertical.
	activityTagsDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_DAYS_NAMES);
	activityTagsDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	activityTagsDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_HOURS_NAMES);
	activityTagsDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	activityTagsDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_NAMES);
	activityTagsDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	activityTagsDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	activityTagsDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	activityTagsDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	activityTagsDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	activityTagsDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_NAMES);
	activityTagsDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	activityTagsDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_CODES);
	
	activityTagsDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_NAMES);
	activityTagsDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	activityTagsDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_CODES);
	
	activityTagsDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_NAMES);
	activityTagsDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	activityTagsDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_CODES);

	activityTagsDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	activityTagsDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	activityTagsDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_LEGEND);
	activityTagsDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_LEGEND);
	activityTagsDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_LEGEND);
	activityTagsDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////activity tags time horizontal and time vertical.
	activityTagsTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_DAYS_NAMES);
	activityTagsTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_DAYS_LONG_NAMES);

	activityTagsTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_HOURS_NAMES);
	activityTagsTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	activityTagsTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_NAMES);
	activityTagsTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	activityTagsTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_CODES);
	
	activityTagsTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	activityTagsTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	activityTagsTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	activityTagsTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_NAMES);
	activityTagsTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	activityTagsTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_CODES);
	
	activityTagsTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_NAMES);
	activityTagsTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	activityTagsTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_CODES);
	
	activityTagsTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_NAMES);
	activityTagsTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	activityTagsTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_CODES);

	activityTagsTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_LEGEND);
	activityTagsTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	activityTagsTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_LEGEND);
	activityTagsTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_LEGEND);
	activityTagsTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_LEGEND);
	activityTagsTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_LEGEND_CODES_FIRST);

	/////activities days horizontal and days vertical.
	activitiesDaysHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_DAYS_NAMES);
	activitiesDaysHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_DAYS_LONG_NAMES);

	activitiesDaysHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_HOURS_NAMES);
	activitiesDaysHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_HOURS_LONG_NAMES);
	
	activitiesDaysHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_NAMES);
	activitiesDaysHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES);
	activitiesDaysHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_CODES);
	
	activitiesDaysHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES);
	activitiesDaysHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	activitiesDaysHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	activitiesDaysHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_NAMES);
	activitiesDaysHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_LONG_NAMES);
	activitiesDaysHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_CODES);
	
	activitiesDaysHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_NAMES);
	activitiesDaysHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_LONG_NAMES);
	activitiesDaysHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_CODES);
	
	activitiesDaysHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_NAMES);
	activitiesDaysHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_LONG_NAMES);
	activitiesDaysHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_CODES);

	activitiesDaysHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_LEGEND);
	activitiesDaysHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	activitiesDaysHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_LEGEND);
	activitiesDaysHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_LEGEND);
	activitiesDaysHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_LEGEND);
	activitiesDaysHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_LEGEND_CODES_FIRST);
	
	/////activities time horizontal and time vertical.
	activitiesTimeHVDaysNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_DAYS_NAMES);
	activitiesTimeHVDaysLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_DAYS_LONG_NAMES);

	activitiesTimeHVHoursNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_HOURS_NAMES);
	activitiesTimeHVHoursLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_HOURS_LONG_NAMES);
	
	activitiesTimeHVSubjectsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_NAMES);
	activitiesTimeHVSubjectsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_LONG_NAMES);
	activitiesTimeHVSubjectsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_CODES);
	
	activitiesTimeHVActivityTagsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES);
	activitiesTimeHVActivityTagsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES);
	activitiesTimeHVActivityTagsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_CODES);
	
	activitiesTimeHVTeachersNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_NAMES);
	activitiesTimeHVTeachersLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_LONG_NAMES);
	activitiesTimeHVTeachersCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_CODES);
	
	activitiesTimeHVStudentsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_NAMES);
	activitiesTimeHVStudentsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_LONG_NAMES);
	activitiesTimeHVStudentsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_CODES);
	
	activitiesTimeHVRoomsNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_NAMES);
	activitiesTimeHVRoomsLongNamesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_LONG_NAMES);
	activitiesTimeHVRoomsCodesCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_CODES);

	activitiesTimeHVSubjectsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_LEGEND);
	activitiesTimeHVActivityTagsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND);
	activitiesTimeHVTeachersLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_LEGEND);
	activitiesTimeHVStudentsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_LEGEND);
	activitiesTimeHVRoomsLegendCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_LEGEND);
	activitiesTimeHVLegendCodesFirstCheckBox->setChecked(SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_LEGEND_CODES_FIRST);
}

SettingsDataToPrintInTimetablesForm::~SettingsDataToPrintInTimetablesForm()
{
	saveFETDialogGeometry(this);
}

void SettingsDataToPrintInTimetablesForm::wasAccepted()
{
	TIMETABLE_HTML_PRINT_SUBJECTS=subjectsCheckBox->isChecked();
	TIMETABLE_HTML_PRINT_ACTIVITY_TAGS=activityTagsCheckBox->isChecked();
	TIMETABLE_HTML_PRINT_TEACHERS=teachersCheckBox->isChecked();
	TIMETABLE_HTML_PRINT_STUDENTS=studentsCheckBox->isChecked();
	TIMETABLE_HTML_PRINT_ROOMS=roomsCheckBox->isChecked();

	//2024-06-12
	SETTINGS_TIMETABLES_SEPARATE_DAYS_NAME_LONG_NAME_BY_BREAK=separateDaysNameLongNameByBreakCheckBox->isChecked();
	SETTINGS_TIMETABLES_SEPARATE_HOURS_NAME_LONG_NAME_BY_BREAK=separateHoursNameLongNameByBreakCheckBox->isChecked();
	SETTINGS_TIMETABLES_SEPARATE_SUBJECTS_NAME_LONG_NAME_CODE_BY_BREAK=separateSubjectsNameLongNameCodeByBreakCheckBox->isChecked();
	SETTINGS_TIMETABLES_SEPARATE_ACTIVITY_TAGS_NAME_LONG_NAME_CODE_BY_BREAK=separateActivityTagsNameLongNameCodeByBreakCheckBox->isChecked();
	SETTINGS_TIMETABLES_SEPARATE_TEACHERS_NAME_LONG_NAME_CODE_BY_BREAK=separateTeachersNameLongNameCodeByBreakCheckBox->isChecked();
	SETTINGS_TIMETABLES_SEPARATE_STUDENTS_NAME_LONG_NAME_CODE_BY_BREAK=separateStudentsNameLongNameCodeByBreakCheckBox->isChecked();
	SETTINGS_TIMETABLES_SEPARATE_BUILDINGS_NAME_LONG_NAME_CODE_BY_BREAK=separateBuildingsNameLongNameCodeByBreakCheckBox->isChecked();
	SETTINGS_TIMETABLES_SEPARATE_ROOMS_NAME_LONG_NAME_CODE_BY_BREAK=separateRoomsNameLongNameCodeByBreakCheckBox->isChecked();
	
	 //only in days horizontal and days vertical.
	SETTINGS_TIMETABLES_PRINT_SUBJECTS_COMMENTS=writeSubjectsCommentsInDaysHVCheckBox->isChecked();
	SETTINGS_TIMETABLES_PRINT_ACTIVITY_TAGS_COMMENTS=writeActivityTagsCommentsInDaysHVCheckBox->isChecked();
	SETTINGS_TIMETABLES_PRINT_TEACHERS_COMMENTS=writeTeachersCommentsInDaysHVCheckBox->isChecked();
	SETTINGS_TIMETABLES_PRINT_SUBGROUPS_COMMENTS=writeSubgroupsCommentsInDaysHVCheckBox->isChecked();
	SETTINGS_TIMETABLES_PRINT_GROUPS_COMMENTS=writeGroupsCommentsInDaysHVCheckBox->isChecked();
	SETTINGS_TIMETABLES_PRINT_YEARS_COMMENTS=writeYearsCommentsInDaysHVCheckBox->isChecked();
	SETTINGS_TIMETABLES_PRINT_BUILDINGS_COMMENTS=writeBuildingsCommentsInDaysHVCheckBox->isChecked();
	SETTINGS_TIMETABLES_PRINT_ROOMS_COMMENTS=writeRoomsCommentsInDaysHVCheckBox->isChecked();
	
	/////subgroups days horizontal and days vertical.
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_DAYS_NAMES=subgroupsDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_DAYS_LONG_NAMES=subgroupsDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_HOURS_NAMES=subgroupsDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_HOURS_LONG_NAMES=subgroupsDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_NAMES=subgroupsDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=subgroupsDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_CODES=subgroupsDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=subgroupsDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=subgroupsDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=subgroupsDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_NAMES=subgroupsDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=subgroupsDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_CODES=subgroupsDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_NAMES=subgroupsDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=subgroupsDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_CODES=subgroupsDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_NAMES=subgroupsDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=subgroupsDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_CODES=subgroupsDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_LEGEND=subgroupsDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=subgroupsDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_LEGEND=subgroupsDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_LEGEND=subgroupsDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_LEGEND=subgroupsDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=subgroupsDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////subgroups time horizontal and time vertical.
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_DAYS_NAMES=subgroupsTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_DAYS_LONG_NAMES=subgroupsTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_HOURS_NAMES=subgroupsTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_HOURS_LONG_NAMES=subgroupsTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_NAMES=subgroupsTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=subgroupsTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_CODES=subgroupsTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=subgroupsTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=subgroupsTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=subgroupsTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_NAMES=subgroupsTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=subgroupsTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_CODES=subgroupsTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_NAMES=subgroupsTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=subgroupsTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_CODES=subgroupsTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_NAMES=subgroupsTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_LONG_NAMES=subgroupsTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_CODES=subgroupsTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_LEGEND=subgroupsTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=subgroupsTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_LEGEND=subgroupsTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_LEGEND=subgroupsTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_LEGEND=subgroupsTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_LEGEND_CODES_FIRST=subgroupsTimeHVLegendCodesFirstCheckBox->isChecked();

	/////groups days horizontal and days vertical.
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_DAYS_NAMES=groupsDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_DAYS_LONG_NAMES=groupsDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_HOURS_NAMES=groupsDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_HOURS_LONG_NAMES=groupsDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_NAMES=groupsDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=groupsDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_CODES=groupsDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=groupsDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=groupsDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=groupsDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_NAMES=groupsDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=groupsDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_CODES=groupsDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_NAMES=groupsDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=groupsDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_CODES=groupsDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_NAMES=groupsDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=groupsDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_CODES=groupsDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_LEGEND=groupsDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=groupsDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_LEGEND=groupsDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_LEGEND=groupsDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_LEGEND=groupsDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=groupsDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////groups time horizontal and time vertical.
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_DAYS_NAMES=groupsTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_DAYS_LONG_NAMES=groupsTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_HOURS_NAMES=groupsTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_HOURS_LONG_NAMES=groupsTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_NAMES=groupsTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=groupsTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_CODES=groupsTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=groupsTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=groupsTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=groupsTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_NAMES=groupsTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=groupsTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_CODES=groupsTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_NAMES=groupsTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=groupsTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_CODES=groupsTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_NAMES=groupsTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_LONG_NAMES=groupsTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_CODES=groupsTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_LEGEND=groupsTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=groupsTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_LEGEND=groupsTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_LEGEND=groupsTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_LEGEND=groupsTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_LEGEND_CODES_FIRST=groupsTimeHVLegendCodesFirstCheckBox->isChecked();

	/////years days horizontal and days vertical.
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_DAYS_NAMES=yearsDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_DAYS_LONG_NAMES=yearsDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_HOURS_NAMES=yearsDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_HOURS_LONG_NAMES=yearsDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_NAMES=yearsDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=yearsDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_CODES=yearsDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=yearsDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=yearsDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=yearsDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_NAMES=yearsDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=yearsDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_CODES=yearsDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_NAMES=yearsDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=yearsDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_CODES=yearsDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_NAMES=yearsDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=yearsDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_CODES=yearsDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_LEGEND=yearsDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=yearsDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_LEGEND=yearsDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_LEGEND=yearsDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_LEGEND=yearsDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=yearsDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////years time horizontal and time vertical.
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_DAYS_NAMES=yearsTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_DAYS_LONG_NAMES=yearsTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_HOURS_NAMES=yearsTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_HOURS_LONG_NAMES=yearsTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_NAMES=yearsTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=yearsTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_CODES=yearsTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=yearsTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=yearsTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=yearsTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_NAMES=yearsTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=yearsTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_CODES=yearsTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_NAMES=yearsTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=yearsTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_CODES=yearsTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_NAMES=yearsTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_LONG_NAMES=yearsTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_CODES=yearsTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_LEGEND=yearsTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=yearsTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_LEGEND=yearsTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_LEGEND=yearsTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_LEGEND=yearsTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_LEGEND_CODES_FIRST=yearsTimeHVLegendCodesFirstCheckBox->isChecked();

	/////teachers days horizontal and days vertical.
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_DAYS_NAMES=teachersDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_DAYS_LONG_NAMES=teachersDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_HOURS_NAMES=teachersDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_HOURS_LONG_NAMES=teachersDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_NAMES=teachersDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=teachersDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_CODES=teachersDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=teachersDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=teachersDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=teachersDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_NAMES=teachersDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=teachersDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_CODES=teachersDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_NAMES=teachersDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=teachersDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_CODES=teachersDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_NAMES=teachersDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=teachersDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_CODES=teachersDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_LEGEND=teachersDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=teachersDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_LEGEND=teachersDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_LEGEND=teachersDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_LEGEND=teachersDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=teachersDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////teachers time horizontal and time vertical.
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_DAYS_NAMES=teachersTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_DAYS_LONG_NAMES=teachersTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_HOURS_NAMES=teachersTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_HOURS_LONG_NAMES=teachersTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_NAMES=teachersTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=teachersTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_CODES=teachersTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=teachersTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=teachersTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=teachersTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_NAMES=teachersTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=teachersTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_CODES=teachersTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_NAMES=teachersTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=teachersTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_CODES=teachersTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_NAMES=teachersTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_LONG_NAMES=teachersTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_CODES=teachersTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_LEGEND=teachersTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=teachersTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_LEGEND=teachersTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_LEGEND=teachersTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_LEGEND=teachersTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_LEGEND_CODES_FIRST=teachersTimeHVLegendCodesFirstCheckBox->isChecked();

	/////rooms days horizontal and days vertical.
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_DAYS_NAMES=roomsDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_DAYS_LONG_NAMES=roomsDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_HOURS_NAMES=roomsDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_HOURS_LONG_NAMES=roomsDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_NAMES=roomsDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=roomsDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_CODES=roomsDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=roomsDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=roomsDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=roomsDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_NAMES=roomsDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=roomsDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_CODES=roomsDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_NAMES=roomsDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=roomsDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_CODES=roomsDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_NAMES=roomsDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=roomsDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_CODES=roomsDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_LEGEND=roomsDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=roomsDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_LEGEND=roomsDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_LEGEND=roomsDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_LEGEND=roomsDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=roomsDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////rooms time horizontal and time vertical.
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_DAYS_NAMES=roomsTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_DAYS_LONG_NAMES=roomsTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_HOURS_NAMES=roomsTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_HOURS_LONG_NAMES=roomsTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_NAMES=roomsTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=roomsTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_CODES=roomsTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=roomsTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=roomsTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=roomsTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_NAMES=roomsTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=roomsTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_CODES=roomsTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_NAMES=roomsTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=roomsTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_CODES=roomsTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_NAMES=roomsTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_LONG_NAMES=roomsTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_CODES=roomsTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_LEGEND=roomsTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=roomsTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_LEGEND=roomsTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_LEGEND=roomsTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_LEGEND=roomsTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_LEGEND_CODES_FIRST=roomsTimeHVLegendCodesFirstCheckBox->isChecked();

	/////buildings days horizontal and days vertical.
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_DAYS_NAMES=buildingsDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_DAYS_LONG_NAMES=buildingsDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_HOURS_NAMES=buildingsDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_HOURS_LONG_NAMES=buildingsDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_NAMES=buildingsDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=buildingsDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_CODES=buildingsDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=buildingsDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=buildingsDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=buildingsDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_NAMES=buildingsDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=buildingsDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_CODES=buildingsDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_NAMES=buildingsDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=buildingsDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_CODES=buildingsDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_NAMES=buildingsDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=buildingsDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_CODES=buildingsDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_LEGEND=buildingsDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=buildingsDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_LEGEND=buildingsDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_LEGEND=buildingsDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_LEGEND=buildingsDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=buildingsDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////buildings time horizontal and time vertical.
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_DAYS_NAMES=buildingsTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_DAYS_LONG_NAMES=buildingsTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_HOURS_NAMES=buildingsTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_HOURS_LONG_NAMES=buildingsTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_NAMES=buildingsTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=buildingsTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_CODES=buildingsTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=buildingsTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=buildingsTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=buildingsTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_NAMES=buildingsTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=buildingsTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_CODES=buildingsTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_NAMES=buildingsTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=buildingsTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_CODES=buildingsTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_NAMES=buildingsTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_LONG_NAMES=buildingsTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_CODES=buildingsTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_LEGEND=buildingsTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=buildingsTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_LEGEND=buildingsTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_LEGEND=buildingsTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_LEGEND=buildingsTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_LEGEND_CODES_FIRST=buildingsTimeHVLegendCodesFirstCheckBox->isChecked();

	/////subjects days horizontal and days vertical.
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_DAYS_NAMES=subjectsDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_DAYS_LONG_NAMES=subjectsDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_HOURS_NAMES=subjectsDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_HOURS_LONG_NAMES=subjectsDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_NAMES=subjectsDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=subjectsDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_CODES=subjectsDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=subjectsDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=subjectsDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=subjectsDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_NAMES=subjectsDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=subjectsDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_CODES=subjectsDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_NAMES=subjectsDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=subjectsDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_CODES=subjectsDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_NAMES=subjectsDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=subjectsDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_CODES=subjectsDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_LEGEND=subjectsDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=subjectsDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_LEGEND=subjectsDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_LEGEND=subjectsDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_LEGEND=subjectsDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=subjectsDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////subjects time horizontal and time vertical.
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_DAYS_NAMES=subjectsTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_DAYS_LONG_NAMES=subjectsTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_HOURS_NAMES=subjectsTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_HOURS_LONG_NAMES=subjectsTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_NAMES=subjectsTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=subjectsTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_CODES=subjectsTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=subjectsTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=subjectsTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=subjectsTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_NAMES=subjectsTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=subjectsTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_CODES=subjectsTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_NAMES=subjectsTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=subjectsTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_CODES=subjectsTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_NAMES=subjectsTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_LONG_NAMES=subjectsTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_CODES=subjectsTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_LEGEND=subjectsTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=subjectsTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_LEGEND=subjectsTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_LEGEND=subjectsTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_LEGEND=subjectsTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_LEGEND_CODES_FIRST=subjectsTimeHVLegendCodesFirstCheckBox->isChecked();

	/////activity tags days horizontal and days vertical.
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_DAYS_NAMES=activityTagsDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_DAYS_LONG_NAMES=activityTagsDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_HOURS_NAMES=activityTagsDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_HOURS_LONG_NAMES=activityTagsDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_NAMES=activityTagsDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=activityTagsDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_CODES=activityTagsDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=activityTagsDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=activityTagsDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=activityTagsDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_NAMES=activityTagsDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=activityTagsDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_CODES=activityTagsDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_NAMES=activityTagsDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=activityTagsDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_CODES=activityTagsDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_NAMES=activityTagsDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_LONG_NAMES=activityTagsDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_CODES=activityTagsDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_LEGEND=activityTagsDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=activityTagsDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_LEGEND=activityTagsDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_LEGEND=activityTagsDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_LEGEND=activityTagsDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_LEGEND_CODES_FIRST=activityTagsDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////activity tags time horizontal and time vertical.
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_DAYS_NAMES=activityTagsTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_DAYS_LONG_NAMES=activityTagsTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_HOURS_NAMES=activityTagsTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_HOURS_LONG_NAMES=activityTagsTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_NAMES=activityTagsTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=activityTagsTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_CODES=activityTagsTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=activityTagsTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=activityTagsTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=activityTagsTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_NAMES=activityTagsTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_LONG_NAMES=activityTagsTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_CODES=activityTagsTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_NAMES=activityTagsTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_LONG_NAMES=activityTagsTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_CODES=activityTagsTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_NAMES=activityTagsTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_LONG_NAMES=activityTagsTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_CODES=activityTagsTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_LEGEND=activityTagsTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=activityTagsTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_LEGEND=activityTagsTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_LEGEND=activityTagsTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_LEGEND=activityTagsTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_LEGEND_CODES_FIRST=activityTagsTimeHVLegendCodesFirstCheckBox->isChecked();

	/////activities days horizontal and days vertical.
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_DAYS_NAMES=activitiesDaysHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_DAYS_LONG_NAMES=activitiesDaysHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_HOURS_NAMES=activitiesDaysHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_HOURS_LONG_NAMES=activitiesDaysHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_NAMES=activitiesDaysHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES=activitiesDaysHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_CODES=activitiesDaysHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES=activitiesDaysHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=activitiesDaysHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES=activitiesDaysHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_NAMES=activitiesDaysHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_LONG_NAMES=activitiesDaysHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_CODES=activitiesDaysHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_NAMES=activitiesDaysHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_LONG_NAMES=activitiesDaysHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_CODES=activitiesDaysHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_NAMES=activitiesDaysHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_LONG_NAMES=activitiesDaysHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_CODES=activitiesDaysHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_LEGEND=activitiesDaysHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND=activitiesDaysHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_LEGEND=activitiesDaysHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_LEGEND=activitiesDaysHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_LEGEND=activitiesDaysHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_LEGEND_CODES_FIRST=activitiesDaysHVLegendCodesFirstCheckBox->isChecked();
	
	/////activities time horizontal and time vertical.
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_DAYS_NAMES=activitiesTimeHVDaysNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_DAYS_LONG_NAMES=activitiesTimeHVDaysLongNamesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_HOURS_NAMES=activitiesTimeHVHoursNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_HOURS_LONG_NAMES=activitiesTimeHVHoursLongNamesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_NAMES=activitiesTimeHVSubjectsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_LONG_NAMES=activitiesTimeHVSubjectsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_CODES=activitiesTimeHVSubjectsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES=activitiesTimeHVActivityTagsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES=activitiesTimeHVActivityTagsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_CODES=activitiesTimeHVActivityTagsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_NAMES=activitiesTimeHVTeachersNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_LONG_NAMES=activitiesTimeHVTeachersLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_CODES=activitiesTimeHVTeachersCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_NAMES=activitiesTimeHVStudentsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_LONG_NAMES=activitiesTimeHVStudentsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_CODES=activitiesTimeHVStudentsCodesCheckBox->isChecked();
	
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_NAMES=activitiesTimeHVRoomsNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_LONG_NAMES=activitiesTimeHVRoomsLongNamesCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_CODES=activitiesTimeHVRoomsCodesCheckBox->isChecked();

	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_LEGEND=activitiesTimeHVSubjectsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND=activitiesTimeHVActivityTagsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_LEGEND=activitiesTimeHVTeachersLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_LEGEND=activitiesTimeHVStudentsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_LEGEND=activitiesTimeHVRoomsLegendCheckBox->isChecked();
	SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_LEGEND_CODES_FIRST=activitiesTimeHVLegendCodesFirstCheckBox->isChecked();

	this->accept();
}

void SettingsDataToPrintInTimetablesForm::wasCanceled()
{
	this->reject();
}
