/*
File timetable_defs.h
*/

/***************************************************************************
                          timetable_defs.h  -  description
                             -------------------
    begin                : Sat Mar 15 2003
    copyright            : (C) 2003 by Liviu Lalescu
    email                : Please see https://lalescu.ro/liviu/ for details about contacting Liviu Lalescu (in particular, you can find there the email address)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU Affero General Public License as        *
 *   published by the Free Software Foundation, either version 3 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef TIMETABLE_DEFS_H
#define TIMETABLE_DEFS_H

#ifdef NDEBUG
#undef NDEBUG
#endif
#include <cassert>

//std::as_const
#include <utility>

#include <QString>

#include <QtGlobal>

#include "utilities.h"

class QWidget;

extern const QString IL1; //indentation levels
extern const QString IL2;
extern const QString IL3;
extern const QString IL4;
extern const QString IL5;

extern bool USE_UNDO_REDO;
extern int UNDO_REDO_STEPS;
//extern int UNDO_REDO_COMPRESSION_LEVEL;

extern bool USE_UNDO_REDO_SAVE;
extern int UNDO_REDO_STEPS_SAVE;
extern QString SUFFIX_FILENAME_SAVE_HISTORY;

extern bool USE_AUTOSAVE;
extern int MINUTES_AUTOSAVE;
extern int OPERATIONS_AUTOSAVE;
extern QString DIRECTORY_AUTOSAVE;
extern QString SUFFIX_FILENAME_AUTOSAVE;

extern bool CONFIRM_ACTIVATE_DEACTIVATE_ACTIVITIES_CONSTRAINTS;

/**
The FET version
*/
extern const QString FET_VERSION;

/**
The version number of the data format, useful when saving/restoring the history to/from the disk.
On any change of the data format, no matter how small or large, this number must be updated;
older or newer data history versions are not compatible.
*/
extern const QString FET_DATA_FORMAT_VERSION;

/**
The FET language
*/
extern QString FET_LANGUAGE;

extern QString FET_LANGUAGE_WITH_LOCALE; //trick to have the Arabic translation use Western numerals

extern bool LANGUAGE_STYLE_RIGHT_TO_LEFT;

extern bool PRINT_RTL;

extern bool PRINT_FROM_INTERFACE;

extern QString LANGUAGE_FOR_HTML;

extern bool OVERWRITE_SINGLE_GENERATION_FILES;

/**
Timetable HTML and CSS JavaScript level, added by Volker Dirr
*/
extern int TIMETABLE_HTML_LEVEL;

extern bool TIMETABLE_HTML_PRINT_ACTIVITY_TAGS;

extern bool TIMETABLE_HTML_PRINT_SUBJECTS;
extern bool TIMETABLE_HTML_PRINT_TEACHERS;
extern bool TIMETABLE_HTML_PRINT_STUDENTS;
extern bool TIMETABLE_HTML_PRINT_ROOMS;

extern bool PRINT_DETAILED_HTML_TIMETABLES;

extern bool PRINT_DETAILED_HTML_TEACHERS_FREE_PERIODS;

extern bool PRINT_NOT_AVAILABLE_TIME_SLOTS;

extern bool PRINT_BREAK_TIME_SLOTS;

extern bool DIVIDE_HTML_TIMETABLES_WITH_TIME_AXIS_BY_DAYS;

extern bool TIMETABLE_HTML_REPEAT_NAMES;

extern bool PRINT_ACTIVITIES_WITH_SAME_STARTING_TIME;

extern QString INTERFACE_STYLE;
extern QString INTERFACE_COLOR_SCHEME;

extern bool SHOW_SUBGROUPS_IN_COMBO_BOXES;
extern bool SHOW_SUBGROUPS_IN_ACTIVITY_PLANNING;

extern bool TIMETABLES_SUBGROUPS_SORTED;

extern bool WRITE_TIMETABLE_CONFLICTS;

extern bool WRITE_TIMETABLES_STATISTICS;
extern bool WRITE_TIMETABLES_XML;
extern bool WRITE_TIMETABLES_DAYS_HORIZONTAL;
extern bool WRITE_TIMETABLES_DAYS_VERTICAL;
extern bool WRITE_TIMETABLES_TIME_HORIZONTAL;
extern bool WRITE_TIMETABLES_TIME_VERTICAL;

extern bool WRITE_TIMETABLES_SUBGROUPS;
extern bool WRITE_TIMETABLES_GROUPS;
extern bool WRITE_TIMETABLES_YEARS;
extern bool WRITE_TIMETABLES_TEACHERS;
extern bool WRITE_TIMETABLES_TEACHERS_FREE_PERIODS;
extern bool WRITE_TIMETABLES_BUILDINGS;
extern bool WRITE_TIMETABLES_ROOMS;
extern bool WRITE_TIMETABLES_SUBJECTS;
extern bool WRITE_TIMETABLES_ACTIVITY_TAGS;
extern bool WRITE_TIMETABLES_ACTIVITIES;

extern bool SHOW_VIRTUAL_ROOMS_IN_TIMETABLES;

//2024-06-12 begin
//
extern bool SETTINGS_TIMETABLES_SEPARATE_DAYS_NAME_LONG_NAME_BY_BREAK;
extern bool SETTINGS_TIMETABLES_SEPARATE_HOURS_NAME_LONG_NAME_BY_BREAK;
extern bool SETTINGS_TIMETABLES_SEPARATE_SUBJECTS_NAME_LONG_NAME_CODE_BY_BREAK;
extern bool SETTINGS_TIMETABLES_SEPARATE_ACTIVITY_TAGS_NAME_LONG_NAME_CODE_BY_BREAK;
extern bool SETTINGS_TIMETABLES_SEPARATE_TEACHERS_NAME_LONG_NAME_CODE_BY_BREAK;
extern bool SETTINGS_TIMETABLES_SEPARATE_STUDENTS_NAME_LONG_NAME_CODE_BY_BREAK;
extern bool SETTINGS_TIMETABLES_SEPARATE_BUILDINGS_NAME_LONG_NAME_CODE_BY_BREAK;
extern bool SETTINGS_TIMETABLES_SEPARATE_ROOMS_NAME_LONG_NAME_CODE_BY_BREAK;

 //only in days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_PRINT_SUBJECTS_COMMENTS;
extern bool SETTINGS_TIMETABLES_PRINT_ACTIVITY_TAGS_COMMENTS;
extern bool SETTINGS_TIMETABLES_PRINT_TEACHERS_COMMENTS;
extern bool SETTINGS_TIMETABLES_PRINT_SUBGROUPS_COMMENTS;
extern bool SETTINGS_TIMETABLES_PRINT_GROUPS_COMMENTS;
extern bool SETTINGS_TIMETABLES_PRINT_YEARS_COMMENTS;
extern bool SETTINGS_TIMETABLES_PRINT_BUILDINGS_COMMENTS;
extern bool SETTINGS_TIMETABLES_PRINT_ROOMS_COMMENTS;

/////subgroups days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////subgroups time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBGROUPS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////groups days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////groups time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_GROUPS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////years days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////years time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_YEARS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////teachers days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////teachers time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_TEACHERS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////rooms days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////rooms time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_ROOMS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////buildings days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////buildings time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_BUILDINGS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////subjects days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////subjects time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_SUBJECTS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////activity tags days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////activity tags time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITY_TAGS_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////activities days horizontal and days vertical.
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_DAYS_HV_PRINT_LEGEND_CODES_FIRST;
/////

/////activities time horizontal and time vertical.
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_DAYS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_DAYS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_HOURS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_HOURS_LONG_NAMES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_LONG_NAMES;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_CODES;

extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_SUBJECTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ACTIVITY_TAGS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_TEACHERS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_STUDENTS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_ROOMS_LEGEND;
extern bool SETTINGS_TIMETABLES_ACTIVITIES_TIME_HV_PRINT_LEGEND_CODES_FIRST;
/////
//
//2024-06-12 end

extern bool SHOW_SHORTCUTS_ON_MAIN_WINDOW;

extern bool SHOW_TOOLTIPS_FOR_CONSTRAINTS_WITH_TABLES;

extern bool SHOW_WARNING_FOR_SUBGROUPS_WITH_THE_SAME_ACTIVITIES;

extern bool SHOW_WARNING_FOR_ACTIVITIES_FIXED_SPACE_VIRTUAL_REAL_ROOMS_BUT_NOT_FIXED_TIME;

extern bool SHOW_WARNING_FOR_MAX_HOURS_DAILY_WITH_UNDER_100_WEIGHT;

extern bool ENABLE_GROUP_ACTIVITIES_IN_INITIAL_ORDER;
extern bool SHOW_WARNING_FOR_GROUP_ACTIVITIES_IN_INITIAL_ORDER;

extern bool CONFIRM_ACTIVITY_PLANNING;
extern bool CONFIRM_SPREAD_ACTIVITIES;
extern bool CONFIRM_REMOVE_REDUNDANT;
extern bool CONFIRM_SAVE_TIMETABLE;

extern bool VERBOSE;

/**
The maximum total number of different subgroups of students
*/
const int MAX_TOTAL_SUBGROUPS=30000;

const int MAX_ROOM_CAPACITY=30000;

/**
The maximum number of activities
DEPRECATED COMMENT BELOW
IMPORTANT: must be qint16 (max 32767), because we are using qint16 for each activity index and for
unallocated activity = max_activities
*/
const int MAX_ACTIVITIES=500000;

/**
The maximum number of rooms
DEPRECATED COMMENT BELOW
IMPORTANT: max_rooms+1 must be qint16 (max 32766 for max_rooms), because we are using qint16 for each room index and
for unallocated space = max_rooms and for unspecified room = max_rooms+1
*/
const int MAX_ROOMS=30000;

/**
The maximum number of buildings
*/
const int MAX_BUILDINGS=30000;

/**
This constant represents an unallocated activity
*/
const int UNALLOCATED_ACTIVITY = MAX_ACTIVITIES;

/**
The maximum number of working hours per day.

IMPORTANT: MAX_HOURS_PER_DAY * MAX_DAYS_PER_WEEK == MAX_HOURS_PER_WEEK must be int (max 2^31-1)
because each time is int and unallocated time is int
*/
const int MAX_HOURS_PER_DAY=1440;

/**
The maximum number of working days per week.

IMPORTANT: MAX_HOURS_PER_DAY * MAX_DAYS_PER_WEEK == MAX_HOURS_PER_WEEK must be int (max 2^31-1)
because each time is int and unallocated time is int
*/
const int MAX_DAYS_PER_WEEK=1000;

//This is a practically chosen value so that the dialog of add activity does not become unresponsive.
const int MAX_SPLIT_OF_AN_ACTIVITY=1000;

/**
The predefined names of the days of the week
*/
//extern const QString PREDEFINED_DAYS_OF_THE_WEEK[];

/**
The maximum number of working hours in a week.

Hours in a week are arranged like this:
         Mo Tu We Th Fr
1        0  1  2  3  4
2        5  6  7  8  9
3        10 11 12 13 14
4        15 16 17 18 19
5        20 21 22 23 24
6        25 26 27 28 29 etc.

IMPORTANT: MAX_HOURS_PER_DAY * MAX_DAYS_PER_WEEK == MAX_HOURS_PER_WEEK must be int (max 2^31-1)
because each time is int and unallocated time is int
*/
const int MAX_HOURS_PER_WEEK = MAX_HOURS_PER_DAY * MAX_DAYS_PER_WEEK;

/**
This constant represents unallocated time for an activity
*/
const int UNALLOCATED_TIME = MAX_HOURS_PER_WEEK;

/**
This constant represents unallocated space for an activity
*/
const int UNALLOCATED_SPACE = MAX_ROOMS;

const int UNSPECIFIED_ROOM = MAX_ROOMS+1;

/**
The maximum number of time constraints
*/
//const int MAX_TIME_CONSTRAINTS = 60000;

/**
The maximum number of space constraints
*/
//const int MAX_SPACE_CONSTRAINTS = 60000;

/**
File and directory separator
*/
extern const QString FILE_SEP;

/**
The timetable's rules input file name
*/
extern QString INPUT_FILENAME_XML;

/**
The working directory
*/
extern QString WORKING_DIRECTORY;

/**
The import directory
*/
extern QString IMPORT_DIRECTORY;

//OUTPUT FILES

/**
The output directory. Please be careful when editing it,
because the functions add a FILE_SEP sign at the end of it
and then the name of a file. If you make OUTPUT_DIR="",
there might be problems.
*/
extern QString OUTPUT_DIR;

/**
A log file explaining how the XML input file was parsed
*/
extern const QString XML_PARSING_LOG_FILENAME;

extern QString CURRENT_OUTPUT_DIRECTORY;
extern QString HIGHEST_OUTPUT_DIRECTORY;

extern QString MULTIPLE_OUTPUT_DIRECTORY;

/**
A function used in XML saving
*/
QString protect(const QString& str);

/**
A function used in HTML saving
*/
QString protect2(const QString& str);

/**
A function used in HTML saving
*/
QString protect2vert(const QString& str);

/**
A function used in HTML saving
*/
//QString protect2id(const QString& str);

/**
A function used in HTML saving
*/
//QString protect2java(const QString& str);

/**
This constants represents free periods of a teacher in the teachers free periods timetable
*/
const int TEACHER_HAS_SINGLE_GAP = 0;
const int TEACHER_HAS_BORDER_GAP = 1;
const int TEACHER_HAS_BIG_GAP = 2;

const int TEACHER_MUST_COME_EARLIER = 4;
const int TEACHER_MUST_COME_MUCH_EARLIER = 6;

const int TEACHER_MUST_STAY_LONGER = 3;
const int TEACHER_MUST_STAY_MUCH_LONGER = 5;		// BE CAREFUL, I just print into LESS_DETAILED timetable, if it's smaller than TEACHER_MUST_STAY_MUCH_LONGER

const int TEACHER_HAS_A_FREE_DAY = 7;

const int TEACHER_IS_NOT_AVAILABLE = 8;

const int TEACHERS_FREE_PERIODS_N_CATEGORIES = 9;

extern bool checkForUpdates;

extern QString internetVersion;

const int STUDENTS_COMBO_BOXES_STYLE_SIMPLE=0;
const int STUDENTS_COMBO_BOXES_STYLE_ICONS=1;
const int STUDENTS_COMBO_BOXES_STYLE_CATEGORIZED=2;
extern int STUDENTS_COMBO_BOXES_STYLE;

///////tricks to save work to reconvert old code
const int CUSTOM_DOUBLE_PRECISION=6; //the maximum number of significant digits after the decimal dot for the weights
const int MULTIPLICANT_DOUBLE_PRECISION=100000000; //10^(2+CUSTOM_DOUBLE_PRECISION)
const int HALF_MULTIPLICANT_DOUBLE_PRECISION=MULTIPLICANT_DOUBLE_PRECISION/2;

void weight_sscanf(const QString& str, const char* fmt, double* result);

class CustomFETString{
public:
	static QString number(int n);
	static QString number(double x);
	static QString numberPlusTwoDigitsPrecision(double x);
};

double customFETStrToDouble(const QString& str, bool* ok=0);
////////////////////////////////////////////////

//Trick found on https://www.qtcentre.org/threads/53066-QMap-sorting-according-to-QLocale
//to create a QMap<QString, ...> ordered by locale order.
//Third post, by ChrisW67.
class LocaleString: public QString{
public:
	LocaleString(const QString& s): QString(s){}
};

inline bool operator<(const LocaleString& lhs, const LocaleString& rhs)
{
	return QString::localeAwareCompare(lhs, rhs)<0;
}
/////////////////////////////////////////////////////

extern bool BEEP_AT_END_OF_GENERATION;
extern bool ENABLE_COMMAND_AT_END_OF_GENERATION;
extern QString commandAtEndOfGeneration;

extern bool BEEP_AT_END_OF_GENERATION_EACH_TIMETABLE;
extern bool ENABLE_COMMAND_AT_END_OF_GENERATION_EACH_TIMETABLE;
extern QString commandAtEndOfGenerationEachTimetable;

//extern bool DETACHED_NOTIFICATION;
//extern int terminateCommandAfterSeconds;
//extern int killCommandAfterSeconds;

//Old RNG below
//for random Knuth - from Knuth TAOCP Vol. 2 Seminumerical Algorithms section 3.6
//these numbers are really important - please do not change them, NEVER!!!
//if you want, write a new random number generator routine, with other name
//I think I found a minor possible improvement, the author said: if(Z<=0) then Z+=MM,
//but I think this would be better: if(Z<=0) then Z+=MM-1. - Yes, the author confirmed.
//The period of this RNG is ~74 quadrilions, according to Knuth ( (2^31-2)*(2^31-250)/62 ~= 7.4*10^16 ).
//Unfortunately, this period is not too long. For the moment I prefer to keep this RNG,
//since changing it is highly critical. But we need to consider the change for the future.
//Changing it will also mean that the method of saving/restoring the seed will need to change.
//extern int XX;
//extern int YY;
/*const int MM=2147483647;
const int AA=48271;
const int QQ=44488;
const int RR=3399;

const int MMM=2147483399;
const int AAA=40692;
const int QQQ=52774;
const int RRR=3791;

void initRandomKnuth();
int randomKnuth1MM1(); //a random between 1 and MM-1
int randomKnuth(int k); //a random between 0 and k-1
*/

//32-bits Random number generator U(0,1): MRG32k3a
//Author: Pierre L'Ecuyer
//Modified: U[0,1), as instructed by the author in his papers.

//Reference for the MRG32k3a random number generator code:

//P. L'Ecuyer, ``Good Parameter Sets for Combined Multiple Recursive
//Random Number Generators'', Shorter version in Operations Research, 47,
//1 (1999), 159--164.
//<https://pubsonline.informs.org/doi/abs/10.1287/opre.47.1.159>

//Includes ideas and code from the files: https://simul.iro.umontreal.ca/rng/MRG32k3a.h, https://simul.iro.umontreal.ca/rng/MRG32k3a.c,
//and/or https://www.iro.umontreal.ca/~lecuyer/myftp/papers/combmrg2.c

//Used with permission from the author, Pierre L'Ecuyer (9 March 2020)

//Modified so that it uses 64-bit integer number operations instead of the not-so-reliable 'double' type.

//The period of this RNG is ~2^191 or ~3*10^57. It has an internal state of 6 32-bit integers.

class MRG32k3a{
public:
	qint64 s10, s11, s12, s20, s21, s22;

	static const qint64 m1;
	static const qint64 m2;
	static const qint64 a12;
	static const qint64 a13n;
	static const qint64 a21;
	static const qint64 a23n;
	
	MRG32k3a();
	~MRG32k3a();
	
	/*
	The seeds for s10, s11, s12 must be integers in [0, m1 - 1] and not all 0.
	The seeds for s20, s21, s22 must be integers in [0, m2 - 1] and not all 0.
	*/
	void initializeMRG32k3a(qint64 _s10, qint64 _s11, qint64 _s12,
	 qint64 _s20, qint64 _s21, qint64 _s22);

	void initializeMRG32k3a();

	unsigned int uiMRG32k3a(); //returns a random number >=0 and <m1

	//double dMRG32k3a(); //returns a uniform real number (double) in the interval [0,1)

	int intMRG32k3a(int k); //returns a random integer >=0 and <k, using the multiplication method recommended in Knuth TAOCP Vol. 2, Section 3.4.1,
		//but implemented using 64-bit numbers. (although I think that we could use the integer division/modulo method, as Knuth additionally notes,
		//since m1 and m2 are prime and so the last bits are also random - but he added that note for a single modulo operation, not for the difference.)
};

#endif
